package gov.va.med.mhv.usermgmt.data.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;
import gov.va.med.mhv.common.data.model.AccessRole;

@Entity
@Table(name = "ACCESS_ROLE_ACCESS_CONTROL")
public class AccessRoleAccessControl extends AbstractBaseEntity {

	private static final long serialVersionUID = 6894299207257654141L;

	@Id
	@Column(name = "ACCESS_ROLE_ACCESS_CONTROL_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "PERMISSIONS")
	private Long permissions;

	@Column(name = "ACCESS_FEATURE_ID", insertable = false, updatable = false)
	private Long accessFeatureId;

	@ManyToOne //(fetch = FetchType.LAZY)
	@JoinColumn(name = "ACCESS_FEATURE_ID")
	private AccessFeature accessFeature;

	@Column(name = "ACCESS_ROLE_ID", insertable = false, updatable = false)
	private Long accessRoleId;

	@ManyToOne //(fetch = FetchType.LAZY)
	@JoinColumn(name = "ACCESS_ROLE_ID")
	private AccessRole accessRole;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getPermissions() {
		return permissions;
	}

	public void setPermissions(Long permissions) {
		this.permissions = permissions;
	}

	public Long getAccessFeatureId() {
		return accessFeatureId;
	}

	public void setAccessFeatureId(Long accessFeatureId) {
		this.accessFeatureId = accessFeatureId;
	}

	public AccessFeature getAccessFeature() {
		return accessFeature;
	}

	public void setAccessFeature(AccessFeature accessFeature) {
		this.accessFeature = accessFeature;
	}

	public Long getAccessRoleId() {
		return accessRoleId;
	}

	public void setAccessRoleId(Long accessRoleId) {
		this.accessRoleId = accessRoleId;
	}

	public AccessRole getAccessRole() {
		return accessRole;
	}

	public void setAccessRole(AccessRole accessRole) {
		this.accessRole = accessRole;
	}
}
